/*
 * Decompiled with CFR 0.152.
 */
package com.porpit.ultimatestack.transform;

import com.porpit.ppcore.transform.PPCoreTransformer;
import com.porpit.ppcore.transform.Transformer;
import java.util.ArrayList;
import java.util.ListIterator;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class UltimateStackTransformer
extends PPCoreTransformer
implements IClassTransformer {
    protected void initTransformers() {
        ArrayList<String> invClassList = new ArrayList<String>();
        invClassList.add("net.minecraft.inventory.InventoryBasic");
        invClassList.add("net.minecraft.entity.player.InventoryPlayer");
        invClassList.add("net.minecraft.inventory.InventoryCrafting");
        invClassList.add("net.minecraft.inventory.InventoryCraftResult");
        invClassList.add("net.minecraft.inventory.InventoryMerchant");
        invClassList.add("net.minecraft.tileentity.TileEntityChest");
        invClassList.add("net.minecraft.tileentity.TileEntityFurnace");
        invClassList.add("net.minecraft.tileentity.TileEntityHopper");
        invClassList.add("net.minecraft.tileentity.TileEntityShulkerBox");
        invClassList.add("net.minecraft.tileentity.TileEntityDispenser");
        invClassList.add("net.minecraft.tileentity.TileEntityBrewingStand");
        invClassList.add("net.minecraft.entity.item.EntityMinecartContainer");
        for (String className : invClassList) {
            this.addTransformer(new Transformer(className){

                public byte[] transform(byte[] data) {
                    ClassReader classReader = new ClassReader(data);
                    ClassNode node = new ClassNode();
                    classReader.accept((ClassVisitor)node, 0);
                    MethodNode m = this.findMethod(node, "getInventoryStackLimit", "()I");
                    AbstractInsnNode currentNode2 = null;
                    for (AbstractInsnNode currentNode2 : m.instructions) {
                        if (!(currentNode2 instanceof IntInsnNode) || ((IntInsnNode)currentNode2).operand != 64) continue;
                        m.instructions.set(currentNode2, (AbstractInsnNode)new IntInsnNode(17, Short.MAX_VALUE));
                        System.out.println("Patched Method:" + this.className + ".getInventoryStackLimit:MaxStackSize");
                    }
                    ClassWriter writer = new ClassWriter(0);
                    node.accept((ClassVisitor)writer);
                    return writer.toByteArray();
                }
            });
        }
        this.addTransformer(new Transformer("net.minecraft.inventory.InventoryHelper"){

            public byte[] transform(byte[] data) {
                ClassReader classReader = new ClassReader(data);
                ClassNode node = new ClassNode();
                classReader.accept((ClassVisitor)node, 0);
                MethodNode m = this.findMethod(node, "spawnItemStack", "(Lnet/minecraft/world/World;DDDLnet/minecraft/item/ItemStack;)V");
                AbstractInsnNode currentNode2 = null;
                for (AbstractInsnNode currentNode2 : m.instructions) {
                    if (!(currentNode2 instanceof FieldInsnNode) || !((FieldInsnNode)currentNode2).name.equals(this.patchFieldName("RANDOM")) || !(currentNode2.getNext() instanceof IntInsnNode) || ((IntInsnNode)currentNode2.getNext()).operand != 21) continue;
                    m.instructions.set(currentNode2.getNext(), (AbstractInsnNode)new IntInsnNode(17, 10922));
                    System.out.println("Patched Method:" + this.className + ".spawnItemStack:Random Range");
                }
                ClassWriter writer = new ClassWriter(0);
                node.accept((ClassVisitor)writer);
                return writer.toByteArray();
            }
        });
        this.addTransformer(new Transformer("org.spongepowered.common.item.inventory.util.ContainerUtil"){

            public byte[] transform(byte[] data) {
                ClassReader classReader = new ClassReader(data);
                ClassNode node = new ClassNode();
                classReader.accept((ClassVisitor)node, 0);
                MethodNode m = this.findMethod(node, "performBlockInventoryDrops", "(Lnet/minecraft/world/WorldServer;DDDLnet/minecraft/inventory/IInventory;)V", false);
                if (m != null) {
                    AbstractInsnNode currentNode2 = null;
                    for (AbstractInsnNode currentNode2 : m.instructions) {
                        if (!(currentNode2 instanceof FieldInsnNode) || !((FieldInsnNode)currentNode2).name.equals(this.patchFieldName("RANDOM")) || !(currentNode2.getNext() instanceof IntInsnNode) || ((IntInsnNode)currentNode2.getNext()).operand != 21) continue;
                        m.instructions.set(currentNode2.getNext(), (AbstractInsnNode)new IntInsnNode(17, 7000));
                        System.out.println("Patched Method:" + this.className + ".performBlockInventoryDrops:Random Range");
                    }
                }
                ClassWriter writer = new ClassWriter(0);
                node.accept((ClassVisitor)writer);
                return writer.toByteArray();
            }
        });
        this.addTransformer(new Transformer("net.minecraftforge.common.util.PacketUtil"){

            public byte[] transform(byte[] data) {
                ClassReader classReader = new ClassReader(data);
                ClassNode node = new ClassNode();
                classReader.accept((ClassVisitor)node, 0);
                PPCoreTransformer.spliceClasses((ClassNode)node, (String)"com.porpit.ultimatestack.transform.patch.PacketUtilPatch", (String[])new String[]{"writeItemStackFromClientToServer"});
                ClassWriter writer = new ClassWriter(0);
                node.accept((ClassVisitor)writer);
                return writer.toByteArray();
            }
        });
        this.addTransformer(new Transformer("net.minecraft.network.PacketBuffer"){

            public byte[] transform(byte[] data) {
                return PPCoreTransformer.spliceClasses((byte[])data, (String)"com.porpit.ultimatestack.transform.patch.PacketBufferPatch", (String[])new String[]{"readItemStack", "func_150791_c", "writeItemStack", "func_150788_a"});
            }
        });
        this.addTransformer(new Transformer("net.minecraft.client.renderer.RenderItem"){

            public byte[] transform(byte[] data) {
                ClassReader classReader = new ClassReader(data);
                ClassNode node = new ClassNode();
                classReader.accept((ClassVisitor)node, 0);
                MethodNode m = this.findMethod(node, "renderItemOverlayIntoGUI", "(Lnet/minecraft/client/gui/FontRenderer;Lnet/minecraft/item/ItemStack;IILjava/lang/String;)V");
                AbstractInsnNode currentNode = null;
                ListIterator iter = m.instructions.iterator();
                while (iter.hasNext()) {
                    currentNode = (AbstractInsnNode)iter.next();
                    if (!(currentNode instanceof MethodInsnNode) || currentNode.getOpcode() != 182 || !((MethodInsnNode)currentNode).owner.equals(6.patchClassName((String)"net/minecraft/client/gui/FontRenderer")) || !((MethodInsnNode)currentNode).desc.equals(6.patchDESC((String)"(Ljava/lang/String;FFI)I"))) continue;
                    iter.set(new MethodInsnNode(184, "com/porpit/ultimatestack/transform/patch/RenderItemPatch", "drawItemCountWithShadow", 6.patchDESC((String)"(Lnet/minecraft/client/gui/FontRenderer;Ljava/lang/String;FFI)I"), false));
                    System.out.println("Patched item count render in RenderItem!");
                    break;
                }
                ClassWriter writer = new ClassWriter(0);
                node.accept((ClassVisitor)writer);
                return writer.toByteArray();
            }
        });
        this.addTransformer(new Transformer("net.minecraft.network.NetHandlerPlayServer"){

            public byte[] transform(byte[] data) {
                ClassReader classReader = new ClassReader(data);
                ClassNode node = new ClassNode();
                classReader.accept((ClassVisitor)node, 0);
                MethodNode m = this.findMethod(node, "processCreativeInventoryAction", "(Lnet/minecraft/network/play/client/CPacketCreativeInventoryAction;)V");
                AbstractInsnNode currentNode2 = null;
                for (AbstractInsnNode currentNode2 : m.instructions) {
                    if (!(currentNode2 instanceof MethodInsnNode) || !((MethodInsnNode)currentNode2).name.equals(7.patchMethodName((String)"net.minecraft.item.ItemStack", (String)"getCount", (String)"()I")) || !(currentNode2.getNext() instanceof IntInsnNode)) continue;
                    m.instructions.set(currentNode2.getNext(), (AbstractInsnNode)new IntInsnNode(17, Short.MAX_VALUE));
                    System.out.println("Patched Method:" + this.className + ".processCreativeInventoryAction: Creative Clone");
                }
                ClassWriter writer = new ClassWriter(0);
                node.accept((ClassVisitor)writer);
                return writer.toByteArray();
            }
        });
        this.addTransformer(new Transformer("net.minecraftforge.items.ItemStackHandler"){

            public byte[] transform(byte[] data) {
                ClassReader classReader = new ClassReader(data);
                ClassNode node = new ClassNode();
                classReader.accept((ClassVisitor)node, 0);
                MethodNode m = this.findMethod(node, "getSlotLimit", "(I)I");
                AbstractInsnNode currentNode2 = null;
                for (AbstractInsnNode currentNode2 : m.instructions) {
                    if (!(currentNode2 instanceof IntInsnNode) || ((IntInsnNode)currentNode2).operand != 64) continue;
                    m.instructions.set(currentNode2, (AbstractInsnNode)new IntInsnNode(17, Short.MAX_VALUE));
                    System.out.println("Patched Method:" + this.className + ".getSlotLimit: MaxSlotLimit");
                }
                ClassWriter writer = new ClassWriter(0);
                node.accept((ClassVisitor)writer);
                return writer.toByteArray();
            }
        });
        this.addTransformer(new Transformer("net.minecraft.item.ItemStack"){

            public byte[] transform(byte[] data) {
                data = PPCoreTransformer.spliceClasses((byte[])data, (String)"com.porpit.ultimatestack.transform.patch.ItemStackPatch", (String[])new String[]{"getMaxStackSize", "func_77976_d"});
                ClassReader classReader = new ClassReader(data);
                ClassNode node = new ClassNode();
                classReader.accept((ClassVisitor)node, 0);
                MethodNode m = this.findMethod(node, "writeToNBT", "(Lnet/minecraft/nbt/NBTTagCompound;)Lnet/minecraft/nbt/NBTTagCompound;");
                AbstractInsnNode currentNode2 = null;
                for (AbstractInsnNode currentNode2 : m.instructions) {
                    if (!(currentNode2 instanceof LdcInsnNode) || !((LdcInsnNode)currentNode2).cst.equals("Count")) continue;
                    AbstractInsnNode convertTaget = currentNode2.getNext().getNext().getNext();
                    AbstractInsnNode countMethodTaget = currentNode2.getNext().getNext().getNext().getNext();
                    if (convertTaget instanceof InsnNode && convertTaget.getOpcode() == 145) {
                        m.instructions.set(convertTaget, (AbstractInsnNode)new InsnNode(147));
                        System.out.println("Patched Method:" + this.className + ".writeToNBT: Int to Short");
                    }
                    if (!(countMethodTaget instanceof MethodInsnNode) || !((MethodInsnNode)countMethodTaget).name.equals(9.patchMethodName((String)"net.minecraft.nbt.NBTTagCompound", (String)"setByte", (String)"(Ljava/lang/String;B)V"))) continue;
                    m.instructions.set(countMethodTaget, (AbstractInsnNode)new MethodInsnNode(countMethodTaget.getOpcode(), ((MethodInsnNode)countMethodTaget).owner, 9.patchMethodName((String)"net.minecraft.nbt.NBTTagCompound", (String)"setShort", (String)"(Ljava/lang/String;S)V"), "(Ljava/lang/String;S)V", ((MethodInsnNode)countMethodTaget).itf));
                    System.out.println("Patched Method:" + this.className + ".writeToNBT: Item Count Byte->Short");
                }
                m = this.findMethod(node, "<init>", "(Lnet/minecraft/nbt/NBTTagCompound;)V");
                for (AbstractInsnNode currentNode2 : m.instructions) {
                    AbstractInsnNode countMethodTaget;
                    if (!(currentNode2 instanceof LdcInsnNode) || !((LdcInsnNode)currentNode2).cst.equals("Count") || !((countMethodTaget = currentNode2.getNext()) instanceof MethodInsnNode) || !((MethodInsnNode)countMethodTaget).name.equals(9.patchMethodName((String)"net.minecraft.nbt.NBTTagCompound", (String)"getByte", (String)"(Ljava/lang/String;)B"))) continue;
                    m.instructions.set(countMethodTaget, (AbstractInsnNode)new MethodInsnNode(countMethodTaget.getOpcode(), ((MethodInsnNode)countMethodTaget).owner, 9.patchMethodName((String)"net.minecraft.nbt.NBTTagCompound", (String)"getShort", (String)"(Ljava/lang/String;)S"), "(Ljava/lang/String;)S", ((MethodInsnNode)countMethodTaget).itf));
                    System.out.println("Patched Method:" + this.className + ".<init>: Item Count Byte->Short");
                }
                ClassWriter writer = new ClassWriter(0);
                node.accept((ClassVisitor)writer);
                return writer.toByteArray();
            }
        });
        this.addTransformer(new Transformer("ic2.core.block.invslot.InvSlot"){

            public byte[] transform(byte[] data) {
                ClassReader classReader = new ClassReader(data);
                ClassNode node = new ClassNode();
                classReader.accept((ClassVisitor)node, 0);
                MethodNode m = this.findMethod(node, "<init>", "(Lic2/core/block/TileEntityInventory;Ljava/lang/String;Lic2/core/block/invslot/InvSlot$Access;ILic2/core/block/invslot/InvSlot$InvSide;)V");
                AbstractInsnNode currentNode2 = null;
                for (AbstractInsnNode currentNode2 : m.instructions) {
                    if (!(currentNode2 instanceof FieldInsnNode) || !(currentNode2.getPrevious() instanceof IntInsnNode) || ((IntInsnNode)currentNode2.getPrevious()).operand != 64) continue;
                    m.instructions.set(currentNode2.getPrevious(), (AbstractInsnNode)new IntInsnNode(17, Short.MAX_VALUE));
                    System.out.println("[patched IC2 Method]" + this.className + ".<init>: MaxStackSize");
                }
                ClassWriter writer = new ClassWriter(0);
                node.accept((ClassVisitor)writer);
                return writer.toByteArray();
            }
        });
        this.addTransformer(new Transformer("noppes.npcs.NpcMiscInventory"){

            public byte[] transform(byte[] data) {
                ClassReader classReader = new ClassReader(data);
                ClassNode node = new ClassNode();
                classReader.accept((ClassVisitor)node, 0);
                MethodNode m = this.findMethod(node, "<init>", "(I)V");
                AbstractInsnNode currentNode2 = null;
                for (AbstractInsnNode currentNode2 : m.instructions) {
                    if (!(currentNode2 instanceof FieldInsnNode) || !(currentNode2.getPrevious() instanceof IntInsnNode) || ((IntInsnNode)currentNode2.getPrevious()).operand != 64) continue;
                    m.instructions.set(currentNode2.getPrevious(), (AbstractInsnNode)new IntInsnNode(17, Short.MAX_VALUE));
                    System.out.println("[patched NPC Method]" + this.className + ".<init>: MaxStackSize");
                }
                ClassWriter writer = new ClassWriter(0);
                node.accept((ClassVisitor)writer);
                return writer.toByteArray();
            }
        });
        ArrayList<String> modIInventoryClass = new ArrayList<String>();
        modIInventoryClass.add("cpw.mods.ironchest.common.tileentity.chest.TileEntityIronChest");
        modIInventoryClass.add("cpw.mods.ironchest.common.tileentity.shulker.TileEntityIronShulkerBox");
        modIInventoryClass.add("noppes.npcs.controllers.data.PlayerMail");
        modIInventoryClass.add("noppes.npcs.containers.InventoryNpcTrader");
        modIInventoryClass.add("noppes.npcs.containers.InventoryNPC");
        modIInventoryClass.add("noppes.npcs.containers.SlotNpcBankCurrency");
        modIInventoryClass.add("noppes.npcs.containers.SlotNpcMercenaryCurrency");
        modIInventoryClass.add("noppes.npcs.containers.SlotNpcTraderItems");
        modIInventoryClass.add("noppes.npcs.entity.data.DataInventory");
        for (String className : modIInventoryClass) {
            this.addTransformer(new Transformer(className){

                public byte[] transform(byte[] data) {
                    AbstractInsnNode currentNode2;
                    ClassReader classReader = new ClassReader(data);
                    ClassNode node = new ClassNode();
                    classReader.accept((ClassVisitor)node, 0);
                    MethodNode m = this.findMethod(node, "func_70297_j_", "()I");
                    if (m != null) {
                        currentNode2 = null;
                        for (AbstractInsnNode currentNode2 : m.instructions) {
                            if (!(currentNode2 instanceof IntInsnNode) || ((IntInsnNode)currentNode2).operand != 64) continue;
                            m.instructions.set(currentNode2, (AbstractInsnNode)new IntInsnNode(17, Short.MAX_VALUE));
                            System.out.println("[patched Mod Method]" + this.className + ".func_70297_j_: MaxStackSize");
                        }
                    }
                    if ((m = this.findMethod(node, "func_75219_a", "()I")) != null) {
                        currentNode2 = null;
                        for (AbstractInsnNode currentNode2 : m.instructions) {
                            if (!(currentNode2 instanceof IntInsnNode) || ((IntInsnNode)currentNode2).operand != 64) continue;
                            m.instructions.set(currentNode2, (AbstractInsnNode)new IntInsnNode(17, Short.MAX_VALUE));
                            System.out.println("[patched Mod Method]" + this.className + ".func_75219_a: MaxStackSize");
                        }
                    }
                    ClassWriter writer = new ClassWriter(0);
                    node.accept((ClassVisitor)writer);
                    return writer.toByteArray();
                }
            });
        }
    }
}

